function[CounterEx,Lambda,failsafe] = complete_test(n)
tic;
M = pretest(n); % subprogram which gives us all relevant vertices of the 
                % cube.
m = size(M,1);
test_var = zeros(m,1); % Used to record if a vertex is currently in the 
                       %    possible counterexample we construct, and if
                       %    we chose to put it there or if it was implied. 
M = cat(2,M,test_var); % Glue `test_var' to `M'.

threshhold = 2^(n-2);  % If the set is bigger, we have a candidate.
CounterEx = {};        % Save all counterexamples we find in here.
Lambda = [];           % Save the coordinates of the closest point
                       %    (see below).
new_vert = m;          % Position of new vertex to visit next in M
pars.fid = 0;          % Silent mode in sedumi
failsafe = []; % Collect the norms of vectors of counterexamples to see if
               %    it was just a problem with the precision.              
branch = 1;               
% ---- The next is the main routine, going with branch and cut through 
% ---- the tree of all possible combinations.
while new_vert >= n+1 % The first n vertices are always chosen.
    New_Vert = M(new_vert,1:n); % The current vertex to check.
    count_Vec = M(:,n+1); % Check how large the set can still get 
                          %    maximally.
    count_test = length(find(count_Vec >= 0));
    if count_test <= threshhold  
        branch = branch+1;
% ---- In this case we found no counterexample. we go back to the last time 
% ---- we chose to add a vertex and exclude it instead. Also, we then
% ---- delete all assignments of later vertices.
        last_dec = find(count_Vec == 1,1);
        end_check = length(last_dec);
        if end_check == 0 % There is no last vertex chosen, so we are done.
            new_vert = n;
            disp('Done (a)')
        else
            for k = new_vert:last_dec-1
                M(k,n+1) = 0;
            end
            M(last_dec,n+1) = -1;
            new_vert = last_dec-1;
        end
    else
% ---- test if New_Vec is a supervertex of a -1-vertex ----
        minus_verts = (count_Vec == -1);
        Minus_Verts = M(minus_verts,1:n); % List of the vertices we chose 
                                          %    not to be in the list.
        t_one = super_minus(Minus_Verts,New_Vert); % subroutine
        if t_one == 0
            M(new_vert,n+1) = -2;
        else
% ---- test if New_Vec is a subvertex of a +1-vertex ----
            plus_verts = (count_Vec == 1);
            Plus_Verts = M(plus_verts,1:n);
            t_two = sub_plus(Plus_Verts,New_Vert); % subroutine
            if t_two == 0
                M(new_vert,n+1) = 2;
            else
% ---- test if a facet-diam. of New_Vec is implied by a +1-vertex ----
                t_three = facet_plus(Plus_Verts,New_Vert);  % subroutine
                if t_three == 0
                    M(new_vert,n+1) = -1;
                else
% ---- test if the quadr.-partner of New_Vec is implied by a +1-vertex ----
                    t_four = quadr_plus(Plus_Verts,New_Vert);  % subroutine
                    if t_four == 0
                        M(new_vert,n+1) = -1;
                    else
                        M(new_vert,n+1) = 1;
                    end
                end
            end
        end     
        if new_vert == n + 2  
% ---- At this point all choices are made. We now check if the set we got is
% ---- a counterexample or not. If there are still enough vertices, we test
% ---- the set by computing the point in the convex hull with the smallest 
% ---- norm. If it is >1, we have a couonterexample, otherwise we don't.
            count_Vec = M(:,n+1); 
            count_test = length(find(count_Vec >= 0));
            if count_test >= threshhold +1
                cand_verts = (M(:,n+1) >= 0);
                Cand_M = M(cand_verts,1:n); % Collect the vertices in a new
                                            %    matrix. 
                [A,b,c,K]=constraints(Cand_M); % subroutine 
                r = sedumi(A,b,c,K,pars);   % Call sedumi.
                leng = size(Cand_M,1);
                test = roundn(r(leng+1),-7);
                lambda = r(leng+1:length(r)); % Coeff. of the convex comb.
                Lambda = cat(2,Lambda,lambda);
           %     disp('meep')
                if test > 1
                    disp('Counterexample:')
                    disp(Cand_M)
                    CounterEx{length(CounterEx)+1} = Cand_M;
                    failsafe = cat(2,failsafe,test);
                end
                M(new_vert,n+1) = 0;
                count_Vec = M(:,n+1);
                last_dec = find(count_Vec == 1,1);
                for k = new_vert:last_dec-1
                    M(k,n+1) = 0;
                end
                M(last_dec,n+1) = -1;
                new_vert = last_dec;
                branch = branch+1;
            end
        end
        new_vert = new_vert-1;
    end
end
disp(branch)
toc
