function[A,b,c,K] = constraints(M)
% This is to get the constraints for the quadratic cone. We want to find
% the point in the convex hull of the vertices (which are the rows of M)
% with minimal norm.


[m,n] = size(M);
V = M';
% number of variables: m + n + 1

% This gives us the primal form

% ------- minimize t -------
c = sparse([zeros(m,1);1;zeros(n,1)]);

% ------- x_i = sum lambda_j v_ij -------
A = [V,zeros(n,1),-eye(n)];

b = sparse(n,1);

% ------- sum lambda_j = 1 -------
A = [A;ones(1,m),zeros(1,n+1)];

b = [b;1];

% ------- (t,x_1,...,x_n) in Qcone -------
K.l = m;
K.q = n+1;



