function [M] = pretest(n)
% we assume a_i>=a_{i+1}

M = vertices(n); % gives us all vertices with at most n-3 -1's
m = size(M,1);
p = 2^n; % number of the cube-vertices
i = m; % we start with the vertices with many -1's
minimal = floor(n/2); % if there are less -1's, then we cannot find a 
                      % diametral vertex in this program. 
min_two = ceil((n-4)/2)+1;% with less, intern_quadrupel makes no sense

while i >= 1  
    New_Vert = M(i,:);
    possible = length(find(New_Vert == -1));
    if possible >= minimal
        test = intern_dismiss(New_Vert); % subroutine
        if test == 1
            test = intern_quadrupel(New_Vert); % subroutine
            if test == 1
                test = secure_pretest(M,New_Vert); % subroutine
            end
        end
    elseif possible >= min_two 
        test = intern_quadrupel(New_Vert);
    else 
        test = 1;       
        i = 1;
    end
    if test == 0
        M(i,:) = [];
        m = m-1;
    end
    i = i-1;
end

disp('vertices in the cube:')
disp(p)
disp('vertices without self-contradiction:')
disp(m)
disp('ratio:')
disp(m/p)
